function varargout = layout_behavior(varargin)
% LAYOUT MATLAB code for layout.fig
%      LAYOUT, by itself, creates a new LAYOUT or raises the existing
%      singleton*.
%
%      H = LAYOUT returns the handle to a new LAYOUT or the handle to
%      the existing singleton*.
%
%      LAYOUT('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in LAYOUT.M with the given input arguments.
%
%      LAYOUT('Property','Value',...) creates a new LAYOUT or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before layout_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to layout_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help layout

% GLOBALS
global uipanelMargin;
global textLineMargin;

set(0, 'Units', 'pixels');
uipanelMargin = 10;
textLineMargin = 6;  % text line height is determined by querying font size, but this is a buffer on that

% Last Modified by GUIDE v2.5 30-Apr-2014 10:56:00

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @layout_OpeningFcn, ...
                   'gui_OutputFcn',  @layout_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before layout is made visible.
function layout_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to layout (see VARARGIN)

% The first argument will be the videoreader object.
handles.vreader = varargin{1};
handles.eventkeys = varargin{2};
numFrames = handles.vreader.NumberOfFrames;
numEventTypes = length(handles.eventkeys) / 2;
handles.cm = gray(256);

showImage(handles, hObject);

% Initialize the slider to the right dimensions and step size
set(handles.frameflipper_slider, 'Min', 1);
set(handles.frameflipper_slider, 'Max', numFrames);
set(handles.frameflipper_slider, 'SliderStep', [1/numFrames 10/numFrames]);
addlistener(handles.frameflipper_slider, 'Action', @frameflipper_slider_MoveFcn);

% Resize some objects, including the main figure, to take up screen
screenPos = get(0, 'ScreenSize');
figureSquare = screenPos(4)-40;
figureOuterPos = [screenPos(3)-figureSquare 0 figureSquare figureSquare];
set(handles.selectROIs_figure, 'OuterPosition', figureOuterPos);

% Stores the vector of events for each frame, with the last column used to
% mark frames in which the worm was "missing" and therefore was unscorable.
handles.events = zeros(numFrames, numEventTypes+1);  

% The user can use the bracker keys [ and ] to mark ranges of missing
% frames.  Keep track of the previously clicked anchor in this variable.
% This gets reset to 0 when a pair of anchors has been specified and the
% events has been updated marking the complete range.
handles.missingAnchor = 0;

% Initialize the static text fields that will be used to display whether a
% frame has been annotated for an event or not.

% Populate the updatable strings
updateEventList(handles);
set(handles.frame_num_text, 'String', ['1/' num2str(numFrames)]);

% Choose default command line output for layout
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);


% UIWAIT makes layout wait for user response (see UIRESUME)
% uiwait(handles.selectROIs_figure);


% --- Outputs from this function are returned to the command line.
function varargout = layout_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on slider movement.
function frameflipper_slider_Callback(hObject, eventdata, handles)
% hObject    handle to frameflipper_slider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider


% --- Executes during object creation, after setting all properties.
function frameflipper_slider_CreateFcn(hObject, eventdata, handles)
% hObject    handle to frameflipper_slider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end

% ---
function frameflipper_slider_MoveFcn(hObject, eventdata)
handles = guidata(hObject);
set(handles.frameflipper_slider, 'Value', getCurrentFrame(handles));  % Necessary to prevent overflow
showImage(handles, hObject);
set(handles.frame_num_text, 'String', ...
    [num2str(getCurrentFrame(handles)) '/' num2str(handles.vreader.NumberOfFrames)]);
updateEventList(handles);


% --- Executes on button press in auto_radiobutton.
function auto_radiobutton_Callback(hObject, eventdata, handles)
% hObject    handle to auto_radiobutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of auto_radiobutton


% --- Executes on button press in manual_radiobutton.
function manual_radiobutton_Callback(hObject, eventdata, handles)
% hObject    handle to manual_radiobutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of manual_radiobutton



function min_edit_Callback(hObject, eventdata, handles)
% hObject    handle to min_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of min_edit as text
%        str2double(get(hObject,'String')) returns contents of min_edit as a double


% --- Executes during object creation, after setting all properties.
function min_edit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to min_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function max_edit_Callback(hObject, eventdata, handles)
% hObject    handle to max_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of max_edit as text
%        str2double(get(hObject,'String')) returns contents of max_edit as a double


% --- Executes during object creation, after setting all properties.
function max_edit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to max_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --------------------------------------------------------------------
function uipushtool2_ClickedCallback(hObject, eventdata, handles)
% hObject    handle to uipushtool2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


%---
function updateEnable(handles, state) 

set(handles.min_text, 'Enable', state, 'Visible', state);
set(handles.max_text, 'Enable', state, 'Visible', state);
set(handles.min_edit, 'Enable', state, 'Visible', state);
set(handles.max_edit, 'Enable', state, 'Visible', state);
set(handles.apply_pushbutton, 'Enable', state, 'Visible', state);



% --- Executes when selectROIs_figure is resized.
function selectROIs_figure_ResizeFcn(hObject, eventdata, handles)
% hObject    handle to selectROIs_figure (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% This function is called even on the initial display (not just resize), so
% do all dynamic layout decisions here.

% Get some useful variables first.
global uipanelMargin;
%global textLineMargin;

sliderPos = get(handles.frameflipper_slider, 'Position');
sliderHeight = sliderPos(4);
figurePos = get(handles.selectROIs_figure, 'Position');
figureHeight = figurePos(4);
figureWidth = figurePos(3);
frameTextPos = get(handles.frame_num_text, 'Position');
frameTextY = frameTextPos(2);
frameTextHeight = frameTextPos(4);
finishedPos = get(handles.finished_pushbutton, 'Position');
finishedWidth = finishedPos(3);
optionsPos = get(handles.options_panel, 'Position');

% Move image axes to top left corner and adjust height based on height of slider
imagePos = [0 sliderHeight figureWidth-finishedWidth-2*uipanelMargin figureHeight-sliderHeight];
set(handles.image_axes, 'Position', imagePos);
% Move slider to be below image axes and adjust width based on figure width
sliderPos = [0 0 figureWidth-finishedWidth-2*uipanelMargin sliderPos(4)];
set(handles.frameflipper_slider, 'Position', sliderPos);
% Move Finished button to right of slider
finishedPos = [sliderPos(3)+uipanelMargin uipanelMargin/4 finishedPos(3) finishedPos(4)];
set(handles.finished_pushbutton, 'Position', finishedPos);
% Move Frame # text to be above button
frameTextPos = [finishedPos(1) finishedPos(4)+uipanelMargin frameTextPos(3) frameTextPos(4)];
set(handles.frame_num_text, 'Position', frameTextPos);
optionsPos = [finishedPos(1) frameTextPos(2)+frameTextPos(4)+uipanelMargin ...
              optionsPos(3) optionsPos(4)];
set(handles.options_panel, 'Position', optionsPos);

% Move Event types to upper right corner of screen, if stored in handles
if (isfield(handles, 'eventkeys'))
    %textHeight = get(handles.frameEventsText, 'FontSize') + textLineMargin;
    %eventsTextHeight = length(handles.eventkeys)/2 * textHeight;
    eventsTextHeight = figureHeight - (frameTextY + 2*frameTextHeight + uipanelMargin);
    frameEventsTextPos = [finishedPos(1) frameTextY + frameTextHeight...
                          finishedPos(3) eventsTextHeight];
    set(handles.frame_events_text, 'Position', frameEventsTextPos);
end

guidata(hObject, handles);


% --- Executes on key press with focus on selectROIs_figure and none of its controls.
function selectROIs_figure_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to selectROIs_figure (see GCBO)
% eventdata  structure with the following fields (see FIGURE)
%	Key: name of the key that was pressed, in lower case
%	Character: character interpretation of the key(s) that was pressed
%	Modifier: name(s) of the modifier key(s) (i.e., control, shift) pressed
% handles    structure with handles and user data (see GUIDATA)
passFocusToSlider(hObject, eventdata, handles);
handleKeyPress(hObject, eventdata, handles);

% --- Executes on key press with focus on frameflipper_slider and none of its controls.
function frameflipper_slider_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to frameflipper_slider (see GCBO)
% eventdata  structure with the following fields (see UICONTROL)
%	Key: name of the key that was pressed, in lower case
%	Character: character interpretation of the key(s) that was pressed
%	Modifier: name(s) of the modifier key(s) (i.e., control, shift) pressed
% handles    structure with handles and user data (see GUIDATA)
handleKeyPress(hObject, eventdata, handles);


%--- Takes into account the current heatmap setting and then uses imshow
function showImage(handles, hObject)

frNum = getCurrentFrame(handles);
frame = read(handles.vreader, frNum);
xlim = get(handles.image_axes, 'XLim');
ylim = get(handles.image_axes, 'YLim');
maplim = [0 255];

imshow(frame(:,:,1), 'Parent', handles.image_axes, 'DisplayRange', maplim, ...
    'Colormap', handles.cm , 'InitialMagnification', 'fit');
    
% Maintain current zoom and pan while flipping through frames
if (~(xlim(1) == 0 && xlim(2) == 1 && ylim(1) == 0 && ylim(2) == 1))
    set(handles.image_axes, 'XLim', xlim, 'YLim', ylim);
end

guidata(hObject, handles);


%-----
function disableAllOthers(hObject, others)

for i=2:length(others)  % Start with second because first object is the toolbar itself
    if (others(i) ~= hObject)
        set(others(i), 'State', 'off');
    end
end

% -----
% When the position of an ROI is manually changed, all subsequent frames
% are also changed.
function updateROIPos(pos, hObject)
handles = guidata(hObject);
curFrameNum = getCurrentFrame(handles);
firstFrameNum = 1;
if (handles.manuallyMovingROIs)
    firstFrameNum = curFrameNum;
end
for i = firstFrameNum:handles.vreader.NumberOfFrames
    handles.roiPos{i, handles.curROINum} = pos;
end
guidata(hObject, handles);

%-----
function updateROIBGPos(pos, hObject)
handles = guidata(hObject);
curFrameNum = getCurrentFrame(handles);
firstFrameNum = 1;
if (handles.manuallyMovingROIs)
    firstFrameNum = curFrameNum;
end
for i = firstFrameNum:handles.vreader.NumberOfFrames
    handles.roiPos{i, handles.numROI + 1} = pos;
end
guidata(hObject, handles);


% --------------------------------------------------------------------
function roi_uitoggletool_OnCallback(hObject, eventdata, handles)
% hObject    handle to roi_uitoggletool (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
disableAllOthers(hObject, findall(handles.uitoolbar1));
h = impoly;
handles.curROINum = handles.curROINum + 1;
setColor(h, 'red');
addNewPositionCallback(h, @(pos)updateROIPos(pos, hObject));
% Set the ROIs position on all frames when the ROI is initially created.
for i = 1:handles.vreader.NumberOfFrames
    handles.roiPos{i, handles.curROINum} = h.getPosition();
end
guidata(hObject, handles);


% --------------------------------------------------------------------
function roibg_uitoggletool_OnCallback(hObject, eventdata, handles)
% hObject    handle to roibg_uitoggletool (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
disableAllOthers(hObject, findall(handles.uitoolbar1));
h = impoly;
setColor(h, 'blue');
addNewPositionCallback(h, @(pos)updateROIBGPos(pos, hObject));
% Set the ROIs position on all frames when the ROI is initially created.
for i = 1:handles.vreader.NumberOfFrames
    handles.roiPos{i, handles.numROI+1} = h.getPosition();
end
guidata(hObject, handles);


% --------------------------------------------------------------------
function zoomin_uitoggletool_OnCallback(hObject, eventdata, handles)
% hObject    handle to zoomin_uitoggletool (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
disableAllOthers(hObject, findall(handles.uitoolbar1));


% --------------------------------------------------------------------
function zoomout_uitoggletool_OnCallback(hObject, eventdata, handles)
% hObject    handle to zoomout_uitoggletool (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
disableAllOthers(hObject, findall(handles.uitoolbar1));


% --------------------------------------------------------------------
function pan_uitoggletool_OnCallback(hObject, eventdata, handles)
% hObject    handle to pan_uitoggletool (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
disableAllOthers(hObject, findall(handles.uitoolbar1));


% --------------------------------------------------------------------
function datacursor_uitoggletool_OnCallback(hObject, eventdata, handles)
% hObject    handle to datacursor_uitoggletool (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
disableAllOthers(hObject, findall(handles.uitoolbar1));


% --- Executes on button press in finished_pushbutton.
function finished_pushbutton_Callback(hObject, eventdata, handles)
% hObject    handle to finished_pushbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% This sends the signal to the calling function to start processing!
set(handles.selectROIs_figure, 'Pointer', 'watch');



function frame_step_edit_Callback(hObject, eventdata, handles)
% hObject    handle to frame_step_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of frame_step_edit as text
%        str2double(get(hObject,'String')) returns contents of frame_step_edit as a double
numFrames = handles.vreader.NumberOfFrames;
fs = str2double(get(handles.frame_step_edit, 'String'));
set(handles.frameflipper_slider, 'SliderStep', [fs/numFrames 10*fs/numFrames]);



% --- Executes during object creation, after setting all properties.
function frame_step_edit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to frame_step_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% -- UTIL FUNCTIONS -- %
function cf = getCurrentFrame(handles)
cf = getAnotherFrame(handles, 0);

function cf = getAnotherFrame(handles, inc)
cf = round(get(handles.frameflipper_slider, 'Value'));
cf = cf + inc;
if (cf < 1)
    cf = 1;
elseif (cf > handles.vreader.NumberOfFrames)
    cf = handles.vreader.NumberOfFrames;
end

function passFocusToSlider(hObject, eventdata, handles)
uicontrol(handles.frameflipper_slider);
fs = str2double(get(handles.frame_step_edit, 'String'));
if (strcmp(eventdata.Key, 'rightarrow'))
    set(handles.frameflipper_slider, 'Value', getAnotherFrame(handles, fs));
    showImage(handles, hObject);
elseif (strcmp(eventdata.Key, 'leftarrow'))
    set(handles.frameflipper_slider, 'Value', getAnotherFrame(handles, -fs));
    showImage(handles, hObject);
end
set(handles.frame_num_text, 'String', ...
    [num2str(getCurrentFrame(handles)) '/' num2str(handles.vreader.NumberOfFrames)]);

function updateEventList(handles)
str = genStaticString(handles);
set(handles.frame_events_text, 'String', str);

function str = genStaticString(handles)
frameNum = getCurrentFrame(handles);
eventkeys = handles.eventkeys;
events = handles.events;
str = ['Frame #' num2str(frameNum) 10 13 10 13];
for i=1:2:length(eventkeys)
    str = [str eventkeys{i} ' [' upper(eventkeys{i+1}) ']: ' 10 13];
    val = events(frameNum, round(i/2));
    if (val ~= 0)
        str = [str 'YES'];
    else
        str = [str 'no'];
    end
    str = [str 10 13 10 13];  % 10 and 13 are the same as \n and \r
end
str = [str 'Missing [M]: '];
if (events(frameNum, end) ~= 0)
    str = [str 'YES'];
else
    str = [str 'no'];
end

% If one anchor of a missing range has been set, display that anchor's
% frame number.
if (handles.missingAnchor ~= 0)
    str = [str 10 13 10 13 'Missing range: ' 10 13 ...
        num2str(handles.missingAnchor) ' - '];  % 10 and 13 are the same as \n and \r
end

function handleKeyPress(hObject, eventdata, handles)
currFrame = getCurrentFrame(handles);
for i=2:2:length(handles.eventkeys)
    if (strcmpi(eventdata.Key, handles.eventkeys{i}))
        if(handles.events(currFrame, i/2) == 0)
            handles.events(currFrame, i/2) = 1;
        else
            handles.events(currFrame, i/2) = 0;
        end
    end
end
if (strcmpi(eventdata.Key, 'M'))
    if(handles.events(currFrame, end) == 0)
        handles.events(currFrame, end) = 1;
    else
        handles.events(currFrame, end) = 0;
    end
end
if (strcmpi(eventdata.Key, 'leftbracket') || strcmpi(eventdata.Key, 'rightbracket'))
    if (handles.missingAnchor > 0)  % Invert all the missing values in the events array
        handles.events(handles.missingAnchor:currFrame, end) = ~handles.events(handles.missingAnchor:currFrame, end);
        handles.missingAnchor = 0;  % Reset to blank
    else
        handles.missingAnchor = currFrame;
    end
end
updateEventList(handles);
guidata(hObject, handles);  % write to permanent data store
